/*************************************************************************
 *    CompuCell - A software framework for multimodel simulations of     *
 * biocomplexity problems Copyright (C) 2003 University of Notre Dame,   *
 *                             Indiana                                   *
 *                                                                       *
 * This program is free software; IF YOU AGREE TO CITE USE OF CompuCell  *
 *  IN ALL RELATED RESEARCH PUBLICATIONS according to the terms of the   *
 *  CompuCell GNU General Public License RIDER you can redistribute it   *
 * and/or modify it under the terms of the GNU General Public License as *
 *  published by the Free Software Foundation; either version 2 of the   *
 *         License, or (at your option) any later version.               *
 *                                                                       *
 * This program is distributed in the hope that it will be useful, but   *
 *      WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU    *
 *             General Public License for more details.                  *
 *                                                                       *
 *  You should have received a copy of the GNU General Public License    *
 *     along with this program; if not, write to the Free Software       *
 *      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.        *
 *************************************************************************/

#include <CompuCell3D/ClassRegistry.h>

using namespace CompuCell3D;

#include <CompuCell3D/Simulator.h>
#include <CompuCell3D/Potts3D/Potts3D.h>


#include <BasicUtils/BasicString.h>
#include <BasicUtils/BasicException.h>

using namespace CompuCell3D;


#include <CompuCell3D/Potts3D/CellInventory.h>

#include <iostream>
using namespace std;


#include "TCSDrawFieldsSteppable.h"

TCSDrawFieldsSteppable::TCSDrawFieldsSteppable() {
	
}
TCSDrawFieldsSteppable::~TCSDrawFieldsSteppable() {}


void TCSDrawFieldsSteppable::init(Simulator *simulator, CC3DXMLElement *_xmlData) {
    //cerr << "INITIALIZE TCSDrawFieldsSteppable"<<endl;
  xmlData=_xmlData;
  
  potts = simulator->getPotts();
  cellInventoryPtr=& potts->getCellInventory();
  automaton = potts->getAutomaton();
  fieldG = (WatchableField3D<CellG *> *)potts->getCellFieldG();

  simulator->registerSteerableObject(this);
    
     // define a new data-class (clusterData) for each cell:	
//     BasicClassAccessorBase * clusterDataAccessorPtr=&clusterDataAccessor;
// 	potts->getCellFactoryGroupPtr()->registerClass(clusterDataAccessorPtr); //this is to register the BasicclassAccessor to the large factory file

    bool boundaryPixelTrackerAlreadyRegisteredFlag;
    boundaryPixelTrackerPlugin=(BoundaryPixelTrackerPlugin*)Simulator::pluginManager.get("BoundaryPixelTracker",&boundaryPixelTrackerAlreadyRegisteredFlag);
    if (!boundaryPixelTrackerAlreadyRegisteredFlag){
            boundaryPixelTrackerPlugin->init(simulator);
    }
    
    bool pixelTrackerAlreadyRegisteredFlag;
    pixelTrackerPlugin=(PixelTrackerPlugin*)Simulator::pluginManager.get("PixelTracker",&pixelTrackerAlreadyRegisteredFlag);
    if (!pixelTrackerAlreadyRegisteredFlag){
            pixelTrackerPlugin->init(simulator);
    }
    
    bool clusterDataTrackerAlreadyRegisteredFlag;
	clusterDataTrackerPlugin=(ClusterDataTrackerPlugin*)Simulator::pluginManager.get("ClusterDataTrackerPlugin",&clusterDataTrackerAlreadyRegisteredFlag);
	if (!clusterDataTrackerAlreadyRegisteredFlag){
		clusterDataTrackerPlugin->init(simulator,_xmlData);
	}
        
//     bool feedbackClusterSteppableAlreadyRegisteredFlag;
// 	fbClusterSteppable=(TCSFeedbackMapsSteppable*)Simulator::steppableManager.get("TCSFeedbackMapsSteppable",&feedbackClusterSteppableAlreadyRegisteredFlag);
// 	if (!feedbackClusterSteppableAlreadyRegisteredFlag){
// 		fbClusterSteppable->init(simulator);
// 	}
        
        
//     bool nTrackerAlreadyRegisteredFlag;
//     nTrackerPlugin=(NeighborTrackerPlugin*)Simulator::pluginManager.get("NeighborTracker",&nTrackerAlreadyRegisteredFlag);
//     if (!nTrackerAlreadyRegisteredFlag){
//             nTrackerPlugin->init(simulator);
//     }
    
    //rand function for probobality funtion, is class
    rand = BasicRandomNumberGenerator::getInstance();

    update(xmlData);
}

void TCSDrawFieldsSteppable::extraInit(Simulator *simulator){
    //PUT YOUR CODE HERE
  //FPDGFB = simulator->getConcentrationFieldByName("PDGFB");
  //FLTGFb = simulator->getConcentrationFieldByName("LTGFb"); 
  //FTGFb = simulator->getConcentrationFieldByName("TGFb"); 
  //FuPAR = simulator->getConcentrationFieldByName("uPAR");
  //FuPA = simulator->getConcentrationFieldByName("uPA");
  FuPARact = simulator->getConcentrationFieldByName("uPARact");
  Fnotch = simulator->getConcentrationFieldByName("notch"); 
  Fdelta = simulator->getConcentrationFieldByName("delta"); 
  Freporter = simulator->getConcentrationFieldByName("reporter"); 
  FVEGFR2 = simulator->getConcentrationFieldByName("VEGFR2"); 
  FVEGF = simulator->getConcentrationFieldByName("VEGF"); 
}

void TCSDrawFieldsSteppable::start(){}

void TCSDrawFieldsSteppable::step(const unsigned int currentStep){
    
    
    //get the dimension values
    fieldDim = potts->getCellFieldG()->getDim();
    int xDim = fieldDim.x;
    int yDim = fieldDim.y;
    int zDim = fieldDim.z;
    
    int i,j,k;
    for(i=0;i<xDim;i++)
        for(j=0;j<yDim;j++)
            for(k=0;k<zDim;k++)
                {
                Point3D pt=Point3D(i,j,k);
                CellG* cell=fieldG->get(pt);
                if (cell )
                    {
                    long int ownClusterId= cell->clusterId;
                    if(clusterDataTrackerPlugin->getIfEC(ownClusterId))
                        {
                        double notchc= clusterDataTrackerPlugin->getNotchConcentration(ownClusterId);
                        double deltac= clusterDataTrackerPlugin->getDeltaConcentration(ownClusterId);
                        double reporterc= clusterDataTrackerPlugin->getReporterConcentration(ownClusterId);
                        //double reporterc= clusterDataTrackerPlugin->getVEGFreporterConcentration(ownClusterId);
                        
                        double VEGFR2c= clusterDataTrackerPlugin->getVEGFR2Concentration(ownClusterId);
                        double uPARc= clusterDataTrackerPlugin->getuPARConcentration(ownClusterId);
                        Fnotch->set(pt,notchc);  
                        Fdelta->set(pt,deltac);
                        Freporter->set(pt,reporterc);
                        FVEGFR2->set(pt,VEGFR2c);
                        FuPARact->set(pt,uPARc);
                        }
                    else
                        {
                        Fnotch->set(pt,0);  
                        Fdelta->set(pt,0);
                        Freporter->set(pt,0);
                        FVEGFR2->set(pt,0);
                        FuPARact->set(pt,0);
                        }
                    }
                else
                    {
                    Fnotch->set(pt,0);  
                    Fdelta->set(pt,0);
                    Freporter->set(pt,0);
                    FVEGFR2->set(pt,0);
                    FuPARact->set(pt,0);
                    }
            }
   
            
}


void TCSDrawFieldsSteppable::update(CC3DXMLElement *_xmlData){
    boundaryStrategy=BoundaryStrategy::getInstance();
    //cerr<<"got here will do neighbor order"<<endl;
    if(_xmlData->getFirstElement("NeighborOrder"))
        maxNeighborIndex=boundaryStrategy->getMaxNeighborIndexFromNeighborOrder(_xmlData->getFirstElement("NeighborOrder")->getUInt());	
    else
        maxNeighborIndex=boundaryStrategy->getMaxNeighborIndexFromNeighborOrder(2);
}

std::string TCSDrawFieldsSteppable::toString(){
   return "TCSDrawFieldsSteppable";
}


std::string TCSDrawFieldsSteppable::steerableName(){
   return toString();
}


